#ifndef DOUBLEVBODATA_H_
#define DOUBLEVBODATA_H_

#include <GLSLProgram/GLSLProgram.h>
#include "VBOData.h"

class DoubleVBOData {
public:
	DoubleVBOData(GLuint pProgram, GLsizei sz, GLenum wPrimitive);
	virtual ~DoubleVBOData();

	void AddGLSLVarying(std::string name);
	void Install();
	int GetPrimitiveCount(void) const;
	int GetVertexCount(void) const;
	void BeginTransformFeedback();
	void EndTransformFeedback();

	bool Draw(void);

	void swapBuffers();

private:
	CFeedbackBuffer * buffer[2];
	int current;
};

#endif /*DOUBLEVBODATA_H_*/
